-------------------------------------------------------------------------
--
--	Licensed Materials - Property of IBM
--
--	5724O4800
--
--	(C) Copyright IBM Corp. 1994, 2014. All Rights Reserved
--
--	US Government Users Restricted Rights - Use, duplication
--	or disclosure restricted by GSA ADP Schedule Contract
--	with IBM Corp.
--
------------------------------------------------------------------------

------------------------------------------------------------------------------
-- CREATE TRIGGERS TO POPULATE TOP NODES TABLE
------------------------------------------------------------------------------

CREATE OR REPLACE TRIGGER sm_top_nodes_insert
GROUP self_monitoring_group
PRIORITY 10
COMMENT 'Populates the top Nodes table on insert.'
BEFORE INSERT ON alerts.status
FOR EACH ROW
begin

	-- IF IT IS A PROBE PERFORMING THE INSERT
	if (%user.app_name = 'PROBE') then

		-- INCREMENT THE TALLY FOR THE INCOMING EVENT NODE
		insert into master.sm_top_nodes ( Node, Tally)
            values ( new.Node, 1);

	-- ELSE IF IT IS TopNodes INFO COMING FROM THE COLLECTION LAYER
	elseif (%user.description = 'collection_gate' and new.AlertGroup = 'TopNodesColl') then

		-- ADD THE INCOMING TOTAL TO THE LOCAL TALLY
		insert into master.sm_top_nodes ( Node, Tally)
            values ( new.Node, new.Grade);
		-- ROW IN ALERTS.STATUS NOT NEEDED
		cancel;
	end if;
end;
go

CREATE OR REPLACE TRIGGER sm_top_nodes_reinsert
GROUP self_monitoring_group
PRIORITY 10
COMMENT 'Populates the top Nodes table on reinsert.'
BEFORE REINSERT ON alerts.status
FOR EACH ROW
begin

	-- IF IT IS A PROBE PERFORMING THE REINSERT
	if (%user.app_name = 'PROBE') then

		-- INCREMENT THE TALLY FOR THE INCOMING EVENT NODE
		insert into master.sm_top_nodes ( Node, Tally)
            values ( new.Node, 1);

	-- ELSE IF IT IS TopNodes INFO COMING FROM THE COLLECTION LAYER
	elseif (%user.description = 'collection_gate' and new.AlertGroup = 'TopNodesColl') then

		-- ADD THE INCOMING TOTAL TO THE LOCAL TALLY
		insert into master.sm_top_nodes ( Node, Tally)
            values ( new.Node, new.Grade);
		-- ROW IN ALERTS.STATUS NOT NEEDED
		cancel;
	end if;
end;
go
