/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tivoli.omnibus.core;

import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.api.ILogger;
import com.ibm.cic.agent.core.api.IMLogger;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.tivoli.omnibus.core.Messages;
import com.ibm.tivoli.omnibus.core.OMNIbusInstallation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PreRequisite
implements ISelectionExpression {
    private static final String BYPASS_ADMIN = "BYPASS_OMNIBUS_ADMIN_CHECK";
    private static final String BYPASS_PREIM = "BYPASS_OMNIBUS_PRE_IM_CHECK";
    private static final String BYPASS_IM = "BYPASS_OMNIBUS_IM_CHECK";
    private static final String BYPASS_ALL = "BYPASS_ALL_OMNIBUS_CHECKS";
    private static final String OMNIBUS_ID = "com.ibm.tivoli.omnibus.core";
    private static final String OMNIBUS_BETA_ID = "com.ibm.tivoli.omnibus.core.beta";
    ILogger logger = IMLogger.getLogger((String)this.getClass().getCanonicalName());

    public IStatus evaluate(ISelectionExpression.EvaluationContext context) {
        IAdaptable adaptable = (IAdaptable)context;
        IAgent agent = (IAgent)adaptable.getAdapter(IAgent.class);
        if (agent.isCheckingPrerequisites()) {
            return this.performPrerequisiteCheck(adaptable, agent);
        }
        return Status.OK_STATUS;
    }

    private IStatus performPrerequisiteCheck(IAdaptable adaptable, IAgent agent) {
        String PLUGIN_ID = "com.ibm.tivoli.omnibus.core.prerequisite";
        if (this.isWindows() && !this.skipPreCheck(BYPASS_ALL)) {
            if (!this.skipPreCheck(BYPASS_ADMIN) && !agent.isAdminMode()) {
                return new Status(4, "com.ibm.tivoli.omnibus.core.prerequisite", -1, Messages.Windows_Administrative_User, null);
            }
            IAgentJob job = (IAgentJob)adaptable.getAdapter(IAgentJob.class);
            if (job.isInstall()) {
                OMNIbusInstallation omnibus = null;
                if (!this.skipPreCheck(BYPASS_IM) && this.isInstalled(agent)) {
                    return new Status(4, "com.ibm.tivoli.omnibus.core.prerequisite", -1, Messages.Found_IM_Installation, null);
                }
                if (!this.skipPreCheck(BYPASS_PREIM)) {
                    omnibus = new OMNIbusInstallation();
                    if (omnibus.getDetectionStatus() && omnibus.isOMNIbusInstalled()) {
                        return new Status(4, "com.ibm.tivoli.omnibus.core.prerequisite", -1, Messages.Found_PreIM_Installation, null);
                    }
                    if (!omnibus.getDetectionStatus()) {
                        return new Status(2, "com.ibm.tivoli.omnibus.core.prerequisite", -1, Messages.Windows_Script_Failed, null);
                    }
                }
            }
        }
        return Status.OK_STATUS;
    }

    private boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    private boolean skipPreCheck(String key) {
        if (System.getProperty(key) != null) {
            this.logger.debug("Bypass property found - " + key + ". Skipping check");
            return true;
        }
        if (System.getenv(key) != null) {
            this.logger.debug("Bypass env value found - " + key + ". Skipping check");
            return true;
        }
        return false;
    }

    private boolean isInstalled(IAgent agent) {
        for (IProfile profile : agent.getAllProfiles()) {
            for (IOffering offering : profile.getInstalledOfferings()) {
                if (!offering.getIdentity().getId().equals(OMNIBUS_ID) && !offering.getIdentity().getId().equals(OMNIBUS_BETA_ID)) continue;
                return true;
            }
        }
        return false;
    }
}

