/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tivoli.omnibus.core.custompanel;

import com.ibm.cic.agent.core.api.ICustomPanelData;
import com.ibm.cic.agent.core.api.ILogger;
import com.ibm.cic.agent.core.api.IMLogger;
import com.ibm.cic.agent.core.custompanel.api.TemplateConstants;
import com.ibm.cic.agent.core.custompanel.api.TemplateCustomPanel;
import com.ibm.cic.agent.core.custompanel.api.TemplateLabel;
import com.ibm.cic.agent.core.custompanel.api.TemplateText;
import com.ibm.cic.agent.core.custompanel.api.TemplateWidgetContainer;
import com.ibm.tivoli.omnibus.core.custompanel.Messages;
import com.ibm.tivoli.omnibus.core.custompanel.Utility;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class MigratePanelConsole
extends TemplateCustomPanel {
    private final int indentSize = 30;
    private final String OMNIBUS = "omnibus.core.";
    private final String MIGRATION_SOURCE = "user.omnibus.core.migrate.src";
    private final TemplateCustomPanel.UserData dirUserData = this.createUserData("user.dirUserData", "Directory description");
    private final TemplateCustomPanel.UserData migrateOMNIbusData = (TemplateCustomPanel.UserData)this.createUserData("user.migratedata", "Migrate OMNIbus data").defaultValue("false");
    private ILogger logger = IMLogger.getLogger((String)((Object)((Object)this)).getClass().getCanonicalName());
    File installDir = null;
    File logFile = null;
    TemplateLabel sourceLabel = null;
    TemplateLabel targetLabel = null;
    TemplateLabel logLabel = null;

    public MigratePanelConsole() {
        super(Messages.MigrateConfigurationDataConsole);
        File omnibus = new File("omnibus");
        File log = new File(omnibus, "log");
        this.logFile = new File(log, "migrate.log");
    }

    public void createWidgets(TemplateWidgetContainer parentContainer) {
        String msgDirectory = null;
        String msgLabel = null;
        if (System.getProperty("os.name").indexOf("Windows") == -1) {
            msgDirectory = Messages.MigrateEnterPreviousDirConsole;
            msgLabel = Messages.MigratePreviousDirConsoleLabel;
        } else {
            msgDirectory = Messages.MigrateEnterDataStoreConsole;
            msgLabel = Messages.MigrateDataStoreConsoleLabel;
        }
        parentContainer.createLabel(msgLabel);
        ((TemplateText)parentContainer.createText(this.dirUserData).style(TemplateConstants.TextStyle.DIRECTORY).description(msgDirectory).consoleKey('D')).triggerUpdate(true);
        parentContainer.createLabel("");
        this.installDir = new File(this.getCustomPanelData().getProfile().getInstallLocation());
        parentContainer.createLabel(Messages.MigrationInformation);
        if (this.dirUserData.getValue().trim().length() == 0) {
            this.sourceLabel = (TemplateLabel)parentContainer.createLabel(Messages.MigrateToBeSkipped).indent(30);
            this.targetLabel = (TemplateLabel)((TemplateLabel)parentContainer.createLabel(NLS.bind((String)Messages.MigrationTargetDirectory, (Object)this.installDir.toString())).enabled(false)).indent(30);
            this.logLabel = (TemplateLabel)((TemplateLabel)parentContainer.createLabel(NLS.bind((String)Messages.MigrationLogFile, (Object)(this.installDir.toString() + File.separator + this.logFile.toString()))).enabled(false)).indent(30);
        } else {
            this.sourceLabel = (TemplateLabel)parentContainer.createLabel(NLS.bind((String)Messages.MigrationSourceDirectory, (Object)this.dirUserData.getValue().trim())).indent(30);
            this.targetLabel = (TemplateLabel)parentContainer.createLabel(NLS.bind((String)Messages.MigrationTargetDirectory, (Object)this.installDir.toString())).indent(30);
            this.logLabel = (TemplateLabel)parentContainer.createLabel(NLS.bind((String)Messages.MigrationLogFile, (Object)(this.installDir.toString() + File.separator + this.logFile.toString()))).indent(30);
        }
    }

    public void updateWidgets(TemplateCustomPanel.UserData userData) {
        if (userData.equals(this.dirUserData) && this.dirUserData.getValue().trim().length() > 0) {
            this.sourceLabel.displayLabel(NLS.bind((String)Messages.MigrationSourceDirectory, (Object)this.dirUserData.getValue().trim()));
            this.targetLabel.enabled(true);
            this.logLabel.enabled(true);
            this.migrateOMNIbusData.setValue("true");
        }
    }

    public void validate(IProgressMonitor monitor) {
        ICustomPanelData cpdata = this.getCustomPanelData();
        String textValue = this.dirUserData.getValue();
        if (textValue == null || textValue.isEmpty()) {
            cpdata.getProfile().removeUserData("user.omnibus.core.migrate.src");
        } else {
            String migrationSourceError = Utility.checkMigrationSource(textValue, this.logger);
            if (migrationSourceError != null) {
                this.dirUserData.error(migrationSourceError, new Object[0]);
            } else {
                cpdata.getProfile().setUserData("user.omnibus.core.migrate.src", textValue);
            }
        }
    }

    public boolean canAddPanelToWizard() {
        return this.getCustomPanelData().getAgent().isConsoleMode();
    }
}

