########################################################################
#
#       Licensed Materials - Property of IBM
#
#       (C) Copyright IBM Corp. 2003. All Rights Reserved
#
#       US Government Users Restricted Rights - Use, duplication
#       or disclosure restricted by GSA ADP Schedule Contract
#       with IBM Corp.
#
#       ========================================================
#       Module Information:
#
#       DESCRIPTION:
#       NSProbe.pm
#
#########################################################################

package NSProbe;
require Exporter;

use strict;
# use warnings; # Uncomment this line if warnings.pm is installed.

use vars qw(@ISA @EXPORT);

@ISA = qw(Exporter);
@EXPORT = qw( Initialise Shutdown LoggingInit Log PropCreate PropCreateInt PropSetValue PropSetValueInt PropGetValue PropGetValueInt PropArgDefine PropArgDefineInt PropFlagDefine PropFlagDefineInt ArgumentProcess ShouldContinue SessionCreateAndConnect SessionDisconnectAndDestroy ProbeWatch SessionFlush EventCreate EventDestroy EventSetElement EventSetEventTimes EventElementExists EventGetElement EventProcess EventDiscard EventRecover LicenseFeature LicenseCheckOut LicenseCheckIn SetEventQueueSize );

sub splitresponse {
	my ( $var ) = @_;
	chomp($var);
	return $var =~ m/([^" ][^ ]*|"(?:[^\\"]|\\.)*")/g;
}

sub encode($) {
	my ( $var ) = @_;

	if ( length($var) == 0  || $var =~ /[\s\n"]/ ) {
		$var =~ s/\\/\\\\/g;
		$var =~ s/\n/\\n/g;
		$var =~ s/\"/\\\"/g;
		$var = "\"$var\"";
	}
	return $var;
}

sub decode($) {
	my $var = shift(@_);

	if ( $var =~ /^"/ ) {
		$var =~ s/^"(.*)"$/$1/;
		$var =~ s/\\\\/\\/g;
		$var =~ s/\\n/\n/g;
		$var =~ s/\\\"/\"/g;
	}

	return $var;
}

BEGIN {
	# Turn off output buffering
	$| = 1;
}

my $last_error = "No error";

sub checkresponse($$) {
	my ( $retcode, $retval ) = @_;

	if ( 0 == $retcode ) {
		$last_error = "No error";
		return 1;
	} else {
		$last_error = "$retcode: $retval";
		return 0;
	}
}

sub getlasterror {
	return $last_error;
}

sub request($$$@) {
	my ( $dummy, $object, $command, @args ) = @_;
	my $arg = "";

	print "0 $object $command";
	foreach $arg (@args) {
		print " ", encode($arg);
	}
	print "\n";

	my $response = <STDIN>;
	chomp($response) or $response = "0 -1 \"Error reading response\"";

	my ( $id, $retcode, $retval ) = splitresponse($response);
	if ( checkresponse($retcode,$retval) ) {
		$_[0] = $retval;
		return 1;
	} else {
		$_[0] = 0;
		return 0;
	}
}

# Context functions
sub Initialise($$$$$$$) {
	my ( $retval, $name, $revision, $description, $date, $machine, $sys ) = @_;

	return request( $_[0], "dummy", "NSProbeInitialise", $name, $revision, $description, $date, $machine, $sys );
}

sub Shutdown() {
	my $retval = "";
	return request( $retval, "dummy", "NSProbeShutdown" );
}

sub LoggingInit($$) {
	my ( $retval, $facility ) = @_;
	return request( $retval, "dummy", "NSProbeLoggingInit", $facility );
}

sub Log($$$) {
	my $retval = "";
	my ( $context, $level, $message ) = @_;
	request( $retval, $context, "NLog", $level, $message );
	return 1;
}

sub PropCreate($$) {
	my $retval = "";
	my ( $context, $prop ) = @_;
	return request( $retval, $context, "NSProbePropCreate", $prop );
}

sub PropCreateInt($$) {
	my $retval = "";
	my ( $context, $prop ) = @_;
	return request( $retval, $context, "NSProbePropCreateInt", $prop );
}

sub PropSetValue($$$) {
	my $retval = "";
	my ( $context, $prop, $value ) = @_;
	return request( $retval, $context, "NSProbePropSetValue", $prop, $value );
}

sub PropSetValueInt($$$) {
	my $retval = "";
	my ( $context, $prop, $value ) = @_;
	return request( $retval, $context, "NSProbePropSetValueInt", $prop, $value );
}

sub PropGetValue($$) {
	my $retval = "";
	my ( $context, $prop ) = @_;
	request( $retval, $context, "NSProbePropGetValue", $prop );
	return ($retval);
}

sub PropGetValueInt($$) {
	my $retval = "";
	my ( $context, $prop ) = @_;
	request( $retval, $context, "NSProbePropGetValueInt", $prop );
	return ($retval) ;
}

sub PropArgDefine($$$$) {
	my $retval = "";
	my ( $context, $name, $prop, $help ) = @_;
	return request( $retval, $context, "NSProbePropArgDefine", $name, $prop, $help );
}

sub PropArgDefineInt($$$$) {
	my $retval = "";
	my ( $context, $name, $prop, $help ) = @_;
	return request( $retval, $context, "NSProbePropArgDefineInt", $name, $prop, $help );
}

sub PropFlagDefine($$$$$) {
	my $retval = "";
	my ( $context, $name, $prop, $help, $value ) = @_;
	return request( $retval, $context, "NSProbePropFlagDefine", $name, $prop, $help, $value );
}

sub PropFlagDefineInt($$$$$) {
	my $retval = "";
	my ( $context, $name, $prop, $help, $value ) = @_;
	return request( $retval, $context, "NSProbePropFlagDefineInt", $name, $prop, $help, $value );
}

sub ArgumentProcess($@) {
	my $retval = "";
	my ( $context, @argv  ) = @_;
	return request( $retval, $context, "NSProbeArgumentProcess", "dummy", @argv );
}

sub ShouldContinue($) {
	my $retval = "";
	my ( $context ) = @_;
	if (request( $retval, $context, "NSProbeShouldContinue" )) {
		return $retval;
	} else {
		return 0;
	}	
}

sub SessionCreateAndConnect($$$$) {
	my ( $session, $context, $serverprop, $rulesprop ) = @_;
	$session = "dummy";
	return request( $_[0], $session, "NSProbeSessionCreateAndConnect", $context, $serverprop, $rulesprop );
}

sub SessionDisconnectAndDestroy($) {
	my ( $session ) = @_;
	return request( $session, $session, "NSProbeSessionDisconnectAndDestroy" );
}

sub ProbeWatch($$$) {
	my ( $session, $severity, $summary ) = @_;
	return request( $session, $session, "NSProbeWatch", $severity, $summary );
}

sub SessionFlush($) {
	my ( $session ) = @_;
	return request( $session, $session, "NSProbeSessionFlush" );
}

sub EventCreate($$) {
	my ( $event, $session ) = @_;
	$event = "dummy";
	return request( $_[0], $event, "NSProbeEventCreate", $session );
}

sub EventDestroy($) {
	my ( $event ) = @_;
	return request( $event, $event, "NSProbeEventDestroy" );
}

sub EventSetElement($$$) {
	my ( $event, $name, $value ) = @_;
	return request( $event, $event, "NSProbeEventSetElement", $name, $value );
}

sub EventSetEventTimes($$) {
	my ( $event, $utc ) = @_;
	return request( $event, $event, "NSProbeEventSetEventTimes", $utc );
}

sub EventElementExists($$) {
	my $retval = "";
	my ( $event, $name ) = @_;
	if (request( $retval, $event, "NSProbeEventSetEventTimes", $name )) {
		return $retval;
	} else {
		return 0;
	}
}

sub EventGetElement($$) {
	my ( $event, $name ) = @_;
	return request( $_[0], $event, "NSProbeEventSetEventTimes", $name );
}

sub EventProcess($) {
	my ( $event ) = @_;
	return request( $event, $event, "NSProbeEventProcess" );
}

sub EventDiscard($) {
	my ( $event ) = @_;
	return request( $event, $event, "NSProbeEventDiscard" );
}

sub EventRecover($) {
	my ( $event ) = @_;
	return request( $event, $event, "NSProbeEventRecover" );
}

sub LicenseFeature($) {
	my $retval = "";
	my ( $license ) = @_;
	return request( $retval, "dummy", "NLicenseFeature", $license );
}

sub LicenseCheckOut() {
	my $retval = "";
	return request( $retval, "dummy", "NLicenseCheckOut" ) ;
}

sub LicenseCheckIn() {
	my $retval = "";
	return request( $retval, "dummy", "NLicenseCheckIn" );
}

sub SetEventQueueSize($) {
	my $retval = "";
	my ( $queueSize ) = @_;
	return request( $retval, "dummy", "NSProbeSetEventQueueSize", $queueSize );
}


